/* 
 * pthread_join.c 
 *
 * Створює 2 потоки, один з яких виводить 300 символів x, а другий -  
 * 200 символів o, і чекає їх завершення, після чого завершує роботу.
 * Ілюструє порядок застосування організації чекання завершення потоків 
 * (функція pthread_join()).
 *
 */

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Параметри для функції print_char() */
struct print_char_params
{
        char c;                 /* Який символ виводити */
        int count;              /* Скільки разів */
};

void *print_char(void *params);


/* Потокова функція.
   Виводить у стандартний потік виведення повідомлень про помилки задане
   число заданих символів. Аргумент params повинен указувати на структуру
   типу print_char_params. */
void *print_char(void *params)
{
        /* Приводить покажчик до потрібного типу. */
        struct print_char_params *p = (struct print_char_params *) params;
        int i;

        for (i = 0; i < p->count; i++)
                fputc(p->c, stderr);
        return NULL;	
}

int main()
{
        pthread_t thread1_id;
        pthread_t thread2_id;
        int terrno;
        /* Інформаційні структури, покажчики на які передаються потокам
           як аргументи */
        struct print_char_params thread1_arg;
        struct print_char_params thread2_arg;

        /* Створює потік, який виводить 300 символів x. */
        thread1_arg.c = 'x';
        thread1_arg.count = 300;
        terrno = pthread_create(&thread1_id, NULL, &print_char,
                                                        &thread1_arg);
        if (terrno != 0)
                fprintf(stderr, "Error creating thread: %s\n",
                                                strerror(terrno));
        /* Створює потік, який виводить 200 символів o. */
        thread2_arg.c = 'o';
        thread2_arg.count = 200;
        terrno = pthread_create(&thread2_id, NULL, &print_char,
                                                        &thread2_arg);
        if (terrno != 0)
                fprintf(stderr, "Error creating thread: %s\n",
                                                strerror(terrno));

        /* Чекає на завершення 1-го потоку. */
        terrno = pthread_join(thread1_id, NULL);
        if (terrno != 0)
                fprintf(stderr, "Error joining thread: %s\n",
                                                strerror(terrno));
        /* Чекає на завершення 2-го потоку. */
        terrno = pthread_join(thread2_id, NULL);
        if (terrno != 0)
                fprintf(stderr, "Error joining thread: %s\n",
                                                strerror(terrno));

        return EXIT_SUCCESS;
}
